# Vespucci 15.0 Highlights

2020-08-06

### End of support for pre Android 4.0 devices

Version 15 no longer supports devices with Android versions older than 4.0 / API 14. We've now migrated the Vespucci code base to use the "androidx" libraries to provide backwards compatibility over multiple Android versions and there is no feasible way to continue to use the old support libraries that would be necessary for older Android versions.

Important note: even though the app will work on Android 4.0 devices, devices with Android version prior to 4.1 do not have TLS 1.2 support that is required for accessing the OpenStreetMap API since August 2nd 2020. If you are experiencing authorization issues on Android versions between 4.1 and 4.4 see [Can't (re-)authenticate - TLS 1.0 / 1.1 issues](http://vespucci.io/tutorials/faq/#cant-re-authenticate-tls-10-11-issues).

### Support for array like semantics for multi-selects

In some circumstances, tags with multiple objects have array-like semantics (that is a fixed number of elements) contrary to being variable length lists. A typical example are lane related tags, which contain the number of elements in the _lanes_ (or _lanes:forward_ and _lanes:backward_) tag. There is no practical difference for tags that need to have a value for every element, but in the case of tags that have free form, potentially empty values, for example _destination:lanes_, there was previously no way of indicating this in the preset.

The current support will add empty fields if the number of elements is lower than the required number, and highlight surplus ones if there are more than the relevant tag requires.  

### Switch to JOSM imagery configuration as default

As you may know, Vespucci has used the "Editor Layer Index" as the source of imagery configuration since version 0.9.4 released in March 2014. ELI was one of the few, if not the only, successful, cross editor projects that reduced the amount of work duplicated across editor development, not to mention reducing the effort by community members to contribute. It was used directly by a number of projects and there was even a degree of synchronisation with JOSM.

Unluckily the iD developers have forked their own branch of ELI potentially making ELI longer term untenable. However JOSMs imagery configuration has come a long way since 2014 and now has feature parity with ELI and the JOSM developers have been kind enough to provide their data in an ELI compatible format.             

Starting with version 15 we now use JOSMs background layer configuration as the default, manual updates can be pulled from the JOSM repository or you can continue use ELI. As updates replace the whole configuration with the exception of custom layers, this means you can effectively switch back to using ELI if necessary.

### Improved layer support

The internal layer support has been rewritten to allow multiple layers of the same kind for layers that support this functionality (background and overlay imagery layers, geojson layer). Layers can be moved up and down in the layer stack. It should be pointed out that adding imagery layers uses a lot of resources and should be used sparingly.

### Mapillary support

A Mapillary layer can now be added to the layer configuration. Clicking on a Mapillary image marker will open the sequence at that marker in a viewer, the forward - backward buttons will navigate along the sequence. On devices with Android 7.0 the viewer starts in a separate activity that can be shown at the same time as the map display if you add them to a multi/split window view. 

Mapillary images are cached on device, the size of the cache (default 100MB) can be set in the advanced preferences.

### Support for WMS endpoints

Vespucci now has support for querying WMS servers and adding layers as custom imagery (similar to how this works in JOSM). Additional WMS servers over the pre-configured ones can be added manually. The functionality can be accessed via the layer dialog menus for the background and overlay layers.

Notes: 

* WMS support continues to be limited to services that provide their layers in either EPSG:3957 or EPSG:4326 projections. 
* You need to make your own determination, just as with custom imagery sources, if the layer you are using is licensed on terms that are compatible with OpenStreetMap.

### Support for barometric sensor and improved elevation support (experimental)

Many Android phones support a pressure sensor that can be used instead of GPS data for determining the current elevation. Support can be turned on in the _Advanced preferences / Location settings_. This will enable using the barometric height in recorded tracks and when creating nodes from the current GPS location.

Android reports elevation as the height about the WGS94 ellipsoid, this is very different (up to many dozens of meters) from what you typically would expect, that is a height above mean sea level. For this reason starting with this release we no longer record the default Android height information in GPX tracks, to get roughly correct data you can either:

* switch to using Android NMEA output (can be selected in the_Advanced preferences / Location settings_, unluckily this has the tendency to be broken and to be more expensive to process,
* or download correction model data to your device (_Install EGM_ from the tools menu),

in both cases elevation data will then be included in your GPX tracks.

### Show current position information

The current WGS84 and related information can now be displayed from the "GPS" menu, the displayed information will automatically update once a second as long as the dialog is shown. As a replacement for the old "create node at current location" functionality such a node can now be created from the dialog.

### Styling for validation errors

Every Vespucci user has seen the violet highlighting that indicates that an object may have an issue. Starting with this release the highlighting style can be configured in a limited fashion, see https://github.com/MarcusWolschon/osmeditor4android/blob/master/documentation/docs/tutorials/data_styling.md The default styles use this to highlight potentially out of date objects in orange.

### Upload selection and update data functions

It is now possible to upload only the currently selected objects, useful for example if you want to save part of an ongoing larger editing session. Further you can now update already downloaded data in place without effecting unsaved edits.
 
### Improvements built-in photo viewer

On Android 7.0 and later devices the view is run as a separate Android activity, this allows it to be used in split screen or popup window mode together with the main app without having to use an external photo viewer.

## Miscellaneous

* Allow copy/pasting over data loads
* Support for translated data style names
* More consistent keyboard support
* Show number of pending edits to upload on menu button 
* Don't use full screen mode if Android 10 gestures are enabled
* Show warning when so much data has been loaded that the app is unlikely to work correctly
* The snackbar shown on an erroneous long press in simple mode has been replaced by a one time tip display and a beep.

# Upgrading from previous versions

* The format of the saved state including data has changed, you should upload any changes before updating.
* Default tile size for some WMS servers has changed, this will lead to distorted imagery for any such tile source for which you already have tiles in the cache. Flush the corresponding tile cache to fix this.
* If you previously had Beta 1 of 15.0 installed you may experience crashes on startup after installing the release version, removing the app specific data via your devices app management user interface  should fix this. Even if you can start the app you should replace any downloaded data with the **Clear and download current view** function or you may experience a crash later on.

# Known problems

* The documentation is out of date.
* Creating issues on github from the app with login / password no longer works. use the pseudo-anonymous issue submission feature.
* For known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)

